/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EffectFirework
extends AbstractEffect {
    public static EffectFirework INSTANCE = new EffectFirework();
    public static FireworkRocketItem.Shape[] shapes = FireworkRocketItem.Shape.values();
    private static List<DyeColor> dyes;

    public EffectFirework() {
        super("firework", "Firework");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveEntity(rayTraceResult, world, shooter, spellStats, spellContext);
        if (!(rayTraceResult.m_82443_() instanceof LivingEntity)) {
            return;
        }
        ItemStack firework = this.getCorrectFirework(spellContext, spellStats, shooter);
        for (int i = 0; i < spellStats.getBuffCount(AugmentSplit.INSTANCE) + 1; ++i) {
            this.spawnFireworkOnEntity(rayTraceResult, world, shooter, firework);
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        super.onResolveBlock(rayTraceResult, world, shooter, spellStats, spellContext);
        ItemStack firework = this.getCorrectFirework(spellContext, spellStats, shooter);
        for (int i = 0; i < spellStats.getBuffCount(AugmentSplit.INSTANCE) + 1; ++i) {
            this.spawnFireworkOnBlock(rayTraceResult, world, shooter, i, firework, spellContext);
        }
    }

    public ItemStack getCorrectFirework(SpellContext spellContext, SpellStats spellStats, LivingEntity shooter) {
        ItemStack firework = EffectFirework.getFirework((int)spellStats.getDurationMultiplier(), (int)spellStats.getAmpMultiplier());
        ItemStack foundStack = this.getItemFromCaster(shooter, spellContext, Items.f_42688_);
        return !foundStack.m_41619_() ? foundStack : firework;
    }

    public void spawnFireworkOnBlock(BlockHitResult rayTraceResult, Level world, LivingEntity shooter, int i, ItemStack fireworkStack, SpellContext context) {
        FireworkRocketEntity fireworkrocketentity;
        if (context.getType() == SpellContext.CasterType.TURRET) {
            BlockPos pos = rayTraceResult.m_82425_();
            Direction direction = rayTraceResult.m_82434_().m_122424_();
            fireworkrocketentity = new FireworkRocketEntity(world, fireworkStack, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, true);
            fireworkrocketentity.m_6686_((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_(), 0.5f, 1.0f);
        } else {
            BlockPos pos = rayTraceResult.m_82425_().m_142300_(rayTraceResult.m_82434_());
            fireworkrocketentity = new FireworkRocketEntity(world, (Entity)shooter, (double)pos.m_123341_() + 0.5 + (double)i * ParticleUtil.inRange(-0.3, 0.3), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + (double)i * ParticleUtil.inRange(-0.3, 0.3), fireworkStack);
        }
        world.m_7967_((Entity)fireworkrocketentity);
    }

    public void spawnFireworkOnEntity(EntityHitResult rayTraceResult, Level world, LivingEntity shooter, ItemStack firework) {
        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(world, firework, (LivingEntity)rayTraceResult.m_82443_());
        fireworkrocketentity.m_5602_((Entity)shooter);
        world.m_7967_((Entity)fireworkrocketentity);
    }

    @Override
    public int getDefaultManaCost() {
        return 50;
    }

    @Override
    public String getBookDescription() {
        return "Creates a firework at the location or entity. Amplify will add Firework Stars, while Extend Time will add additional flight time. If a firework exists in the casters inventory, the created firework will mimic the held one. Spell Turrets with Touch will create fireworks as if they were dispensed.";
    }

    @Override
    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_FIRE);
    }

    @Override
    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentExtendTime.INSTANCE, AugmentAmplify.INSTANCE, AugmentSplit.INSTANCE);
    }

    public static List<DyeColor> getColorfulDyes() {
        if (dyes == null) {
            dyes = Arrays.stream(DyeColor.values()).filter(d -> d != DyeColor.BLACK && d != DyeColor.GRAY && d != DyeColor.LIGHT_GRAY && d != DyeColor.BROWN).collect(Collectors.toList());
        }
        return dyes;
    }

    public static ItemStack getFirework(int numGunpowder, int numStars) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag rocketTag = stack.m_41698_("Fireworks");
        rocketTag.m_128344_("Flight", (byte)numGunpowder);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < numStars; ++i) {
            listnbt.add((Object)EffectFirework.getRandomStar().m_41737_("Explosion"));
        }
        if (!listnbt.isEmpty()) {
            rocketTag.m_128365_("Explosions", (Tag)listnbt);
        }
        return stack;
    }

    public static ItemStack getRandomStar() {
        ItemStack star = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag starTag = star.m_41698_("Explosion");
        Random random = new Random();
        FireworkRocketItem.Shape fireworkrocketitem$shape = shapes[random.nextInt(shapes.length)];
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < random.nextInt(8); ++i) {
            list.add(EffectFirework.getColorfulDyes().get(random.nextInt(EffectFirework.getColorfulDyes().size())).m_41070_());
        }
        starTag.m_128379_("Flicker", random.nextBoolean());
        starTag.m_128379_("Trail", random.nextBoolean());
        starTag.m_128408_("Colors", (List)list);
        starTag.m_128344_("Type", (byte)fireworkrocketitem$shape.m_41236_());
        return star;
    }

    @Override
    public SpellTier getTier() {
        return SpellTier.TWO;
    }
}

